﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.ServiceModel.Activation;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP_SERVICE
{
    /// <summary>
    /// Summary description for DveivrServices
    /// </summary>
    [WebService(Namespace = "http://DNS")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [WebServiceBindingAttribute(Name = "MviServices", Namespace = "http://DNS")]
    [ServiceContract(Name = "MviServices", Namespace = "http://DNS")]
    [System.ComponentModel.ToolboxItem(false)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public partial class DveivrServices : System.Web.Services.WebService
    {
        [WebMethod]
        public List<DVEIVRENCOUNTER> GetNewEncounters(int maxRecords)
        {
            // maxRecords - should zero be unlimited?

            return VIRPManager.GetNewEncounters(maxRecords);
        }
        [WebMethod]
        public int GetNewEncounters_Count()
        {
            return VIRPManager.GetNewEncounters_Count();
        }

        [WebMethod]
        public List<DVEIVRENCOUNTER> GetEncountersByDate(DateTime startDate, DateTime endDate)
        {
            return VIRPManager.GetEncountersByDate(startDate, endDate);
        }
        [WebMethod]
        public int GetEncountersByDate_Count(DateTime startDate, DateTime endDate)
        {
            return VIRPManager.GetEncountersByDate_Count(startDate, endDate);
        }
        [WebMethod]
        public List<DVEIVRENCOUNTER> GetEncountersByRetrieveDate(DateTime startDate, DateTime endDate)
        {
            return VIRPManager.GetEncountersByRetrieveDate(startDate, endDate);
        }
        [WebMethod]
        public int GetEncountersByRetrieveDate_Count(DateTime startDate, DateTime endDate)
        {
            return VIRPManager.GetEncountersByRetrieveDate_Count(startDate, endDate);
        }
    }
}
